using System;
using System.Collections;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Looks up a division definition (code and name) in supplied division list. 
	/// </summary>
	public class dlgVistADivisions : DlgAdminBase
	{	
		private string _initiallySelectedDivisionCode;

		private ICollection _divisions;
		private DivisionDefinition _selectedDivision;

		private VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpVistADivision;
		private System.Windows.Forms.ListView lvVistADivision;
		private System.Windows.Forms.ColumnHeader colCode;
		private System.Windows.Forms.ColumnHeader colName;
		private System.Windows.Forms.HelpProvider helpProvider1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.ComponentModel.IContainer components;

		#region DivisionDefListViewItem Implementation

		private class DivisionDefListViewItem : ListViewItem
		{
			public readonly DivisionDefinition DivisionDef;

			public DivisionDefListViewItem( DivisionDefinition divisionDef )
			{
				if( divisionDef == null )
					throw( new ArgumentNullException( "divisionDef" ) );

				DivisionDef = divisionDef;

				this.SubItems[0].Text = divisionDef.DivisionCode;
				this.SubItems.Add( divisionDef.DivisionName );
			}
		}

		#endregion

		/// <summary>
		/// Constructor
		/// </summary>
		public dlgVistADivisions() : base()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.vbecsLogo1.Title = this.Text;
			this.RequiredFieldsLabel = true;

			_divisions = null;
			_selectedDivision = null;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="divisionsList"></param>
		/// <param name="initiallySelectedDivisionCode"></param>
		public dlgVistADivisions( ICollection divisionsList, string initiallySelectedDivisionCode ) : this()
		{
			_divisions = divisionsList;

			// Null is perfectly fine here. Division does not have to be preselected. 
			_initiallySelectedDivisionCode = initiallySelectedDivisionCode;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(dlgVistADivisions));
			this.btnOK = new VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpVistADivision = new System.Windows.Forms.GroupBox();
			this.lvVistADivision = new System.Windows.Forms.ListView();
			this.colCode = new System.Windows.Forms.ColumnHeader();
			this.colName = new System.Windows.Forms.ColumnHeader();
			this.helpProvider1 = new System.Windows.Forms.HelpProvider();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.grpVistADivision.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(332, 30);
			this.vbecsLogo1.Title = "VistA Divisions";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 212);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Location = new System.Drawing.Point(176, 204);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(256, 204);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpVistADivision
			// 
			this.grpVistADivision.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpVistADivision.Controls.Add(this.lvVistADivision);
			this.grpVistADivision.Location = new System.Drawing.Point(4, 36);
			this.grpVistADivision.Name = "grpVistADivision";
			this.grpVistADivision.Size = new System.Drawing.Size(324, 164);
			this.grpVistADivision.TabIndex = 0;
			this.grpVistADivision.TabStop = false;
			this.grpVistADivision.Text = "Select a VistA Division*";
			// 
			// lvVistADivision
			// 
			this.lvVistADivision.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvVistADivision.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.colCode,
																							  this.colName});
			this.lvVistADivision.FullRowSelect = true;
			this.lvVistADivision.HideSelection = false;
			this.lvVistADivision.Location = new System.Drawing.Point(8, 16);
			this.lvVistADivision.MultiSelect = false;
			this.lvVistADivision.Name = "lvVistADivision";
			this.lvVistADivision.Size = new System.Drawing.Size(308, 140);
			this.lvVistADivision.TabIndex = 0;
			this.lvVistADivision.View = System.Windows.Forms.View.Details;
			this.lvVistADivision.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvVistADivision_ColumnClick);
			this.lvVistADivision.SelectedIndexChanged += new System.EventHandler(this.lvVistADivision_SelectedIndexChanged);
			this.lvVistADivision.Activation = ItemActivation.Standard;
			this.lvVistADivision.ItemActivate += new EventHandler(lvVistADivision_ItemActivate);
			// 
			// colCode
			// 
			this.colCode.Text = "Code";
			// 
			// colName
			// 
			this.colName.Text = "Name";
			this.colName.Width = 243;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// dlgVistADivisions
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(332, 228);
			this.Controls.Add(this.grpVistADivision);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MinimumSize = new System.Drawing.Size(340, 252);
			this.Name = "dlgVistADivisions";
			this.RequiredFieldsLabel = true;
			this.Text = "VistA Divisions";
			this.Load += new System.EventHandler(this.dlgVistADivisions_Load);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpVistADivision, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpVistADivision.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void dlgVistADivisions_Load(object sender, System.EventArgs e)
		{
			this.Refresh();

			using( new WaitCursor() )
				PopulateListView();

			SetThisToolTip( btnCancel, StrRes.Tooltips.MUC02.ClickToCancelVistaDivisionSelection() );
			UpdateOkButton();
		}

		private void PopulateListView()
		{
			if( IsNoDivisionsFoundMode )
			{
				GuiUtility.SetListViewReadonlyErrorMessage( lvVistADivision, StrRes.OtherMsg.MUC02.NoVistADivisionsFound().ResString );
				return;
			}			

			lvVistADivision.BeginUpdate();

			lvVistADivision.Items.Clear();
			GuiUtility.ReenableDetailedListView( lvVistADivision );

			foreach( DivisionDefinition _div in _divisions )
			{
				DivisionDefListViewItem _lvi = new DivisionDefListViewItem( _div );

				lvVistADivision.Items.Add( _lvi );

				if( _div.DivisionCode == _initiallySelectedDivisionCode )
					_lvi.Selected = true;
			}

			lvVistADivision.EndUpdate();
		}

		private void UpdateOkButton()
		{
			btnOK.EnabledButton = ( lvVistADivision.SelectedItems.Count != 0 ) && !IsNoDivisionsFoundMode;

			if( !IsNoDivisionsFoundMode )
				btnOK.SetToolTip( ( btnOK.EnabledButton ? StrRes.Tooltips.MUC02.ClickToSelectVistaDivision() : StrRes.Tooltips.MUC02.PleaseSelectVistaDivision() ).ResString );
			else
				btnOK.SetToolTip( StrRes.Tooltips.MUC02.NoVistaDivisionsFound().ResString );
		}
	
		private void lvVistADivision_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateOkButton();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			_selectedDivision = null;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			_selectedDivision = ((DivisionDefListViewItem)lvVistADivision.SelectedItems[0]).DivisionDef;

			DialogResult = DialogResult.OK;
			this.Close();
		}

		private void lvVistADivision_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			ColumnClickSorter.ColumnClickHandler( sender, e, true, ColumnClickSorter.ColumnSortType.String );
		}

		/// <summary>
		/// Get IsNoDivisionsFoundMode
		/// </summary>
		protected virtual bool IsNoDivisionsFoundMode
		{
			get
			{	
				return _divisions == null || _divisions.Count == 0;
			}
		}

		/// <summary>
		/// Get SelectedVistADivision
		/// </summary>
		public DivisionDefinition SelectedVistADivision
		{
			get
			{
				return _selectedDivision;
			}
		}

		private void lvVistADivision_ItemActivate(object sender, EventArgs e)
		{
			btnOK.PerformClick();
		}
	}
}
